class WorldMinimap
  attr_accessor :w, :h

  def initialize(args)
    @w = 16 * 4
    @h = 8 * 4

    # args.render_target(:world_minimap)
    args.outputs[:world_minimap].w = @w
    args.outputs[:world_minimap].h = @h
    args.outputs[:world_minimap].transient!
    # args.outputs[:world_minimap].transient!
    # args.outputs[:world_minimap].w = @w
    # args.outputs[:world_minimap].h = @h

    @current_room = args.state.player.current_room_coordinates
  end

  def tick(args)
    @current_room = args.state.player.current_room_coordinates
  end

  def draw(args)
    # args.outputs[:world_minimap].w = @w
    # args.outputs[:world_minimap].h = @h
    current_room = @current_room
    args.outputs[:world_minimap].w = @w
    args.outputs[:world_minimap].h = @h
    args.outputs[:world_minimap].transient!

    output = [
      {x: 0, y: 0, w: @w, h: @h, path: :pixel}.merge(Color::GREY),
      {x: current_room.x * 4, y: current_room.y * 4, w: 4, h: 4, path: :pixel}.merge( Color::GREEN)
    ]
    # puts output
    # grid_lines = __get_grid_lines__()
    args.outputs[:world_minimap].primitives << output
    # args.outputs[:world_minimap].primitives << grid_lines
    # args.outputs[:world_minimap].primitives << {x: 0, y: 0, w: @w, h: @h, **Color::GREY, primitive_marker: :solid}
    # args.outputs[:world_minimap].primitives << {x: current_room.x * 4, y: current_room.y * 4, w: 4, h: 4, **Color::GREEN, primitive_marker: :solid}


    args.outputs[:hud].primitives << {x: 25, y: 10, w: @w * 2, h: @h * 2, path: :world_minimap, flip_vertically: true,  primitive_marker: :sprite}
  end

  private

  def __get_grid_lines__()
    tile_w = 4
    tile_h = 4
  
    grid_cell_count_w = (@w / tile_w).to_i
    grid_cell_count_h = (@h / tile_h).to_i
  
    line_color = Color::WHITE
    grid = []
    (1...grid_cell_count_w).each do | x_loc |
      line_hash = {x: (x_loc * tile_w), y: 0, x2: (x_loc * tile_w), y2: @h, primitive_marker: :line }.merge!(**line_color)
      grid << line_hash
    end
  
    (1...grid_cell_count_h).each do | y_loc |
      line_hash = {x: 0, y: (y_loc * tile_h), x2: @w, y2: (y_loc * tile_h), primitive_marker: :line }.merge!(**line_color)
      grid << line_hash
    end

    grid
  end
end